/* - EncoderPositionListener -
 * 
 * The event arguements will provide the encoder index, value, and the elapsed 
 * time since the last event.  These value, including the current position 
 * value stored in the corresponding element in the encoder object could be 
 * used to calculate velocity...
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.EncoderPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.EncoderPositionChangeListener;
import com.phidgets.event.EncoderPositionChangeEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class EncoderPositionListener implements EncoderPositionChangeListener{
    
    private JFrame appFrame;
    private JTextField relChngTxt;
    private JTextField timeTxt;
    private JTextField posTxt;
    
    /**
     * Creates a new instance of EncoderPositionListener
     */
    public EncoderPositionListener(JFrame appFrame, JTextField relChngTxt, JTextField timeTxt, JTextField posTxt)
    {
        this.appFrame = appFrame;
        this.relChngTxt = relChngTxt;
        this.timeTxt = timeTxt;
        this.posTxt = posTxt;
    }

    public void encoderPositionChanged(EncoderPositionChangeEvent encoderPositionChangeEvent)
    {
        try
        {
            EncoderPhidget source = (EncoderPhidget)encoderPositionChangeEvent.getSource();
            relChngTxt.setText(Integer.toString(encoderPositionChangeEvent.getValue()));
            timeTxt.setText(Integer.toString(encoderPositionChangeEvent.getTime()));
            posTxt.setText(Integer.toString(source.getPosition(encoderPositionChangeEvent.getIndex())));
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
